package zone

import 	"fmt"
import 	"strings"
import 	"strconv"
import	"net/http"
import 	"alpha/adDelivery/globalvariables"
import 	config "alpha/configuration"
import 	"alpha/db"
import 	"alpha/adDelivery/structure"
import 	"alpha/adDelivery/ad"
import  "alpha/adDelivery/helper"
import  "alpha/adDelivery/rtbOjbects"
import	"github.com/elliotchance/phpserialize"	
import  "encoding/json"
import 	"bytes"
import "io/ioutil"
import "crypto/md5"
import "alpha/redisClient"
import "time"
import  "database/sql"



var redisClients = redisClient.Initialize()



func LoadAsyncjs() string {
	
	
 data, _ := ioutil.ReadFile("js/async.js")
 jsContent := string(data)
 
 
 
 GO_ETAG :=  fmt.Sprintf("%x",md5.Sum([]byte(config.GetConfig("delivery","webpath")+"*"+config.GetConfig("deliverySSL","webpath"))))
 GO_PRODUCT := config.GetConfig("product","var")
 GO_ASYNC_DELIVERY  := config.GetConfig("commonpath","file")+config.GetConfig("asyncspc","file")
 
 jsContent = strings.ReplaceAll(jsContent, "GO_ETAG", GO_ETAG)
 jsContent = strings.ReplaceAll(jsContent, "GO_PRODUCT", GO_PRODUCT)
 jsContent = strings.ReplaceAll(jsContent, "GO_ASYNC_DELIVERY", GO_ASYNC_DELIVERY)

 return jsContent


	
}
	
	
	


func GetExternalAds(r *http.Request,zninfo structure.ZoneInfo,tag_type string, adDeliveryType string) (string ,bool)  {
		
	 adQuery :=""
	 var err error
	 var rows *sql.Rows
	 
	table_prefix := config.GetConfig("prefix","table")
	 zoneExtra := structure.AdExchangeZone{}


		zone_id_str := strconv.Itoa(zninfo.Zoneid)

	redisClients.GetKey("zonexchange"+zone_id_str,&zoneExtra)
	
	if(zoneExtra.Zoneid ==0  ) {
		
 
 	 adQuery = "SELECT * FROM "+table_prefix+"exchange_zone_assoc WHERE zoneid = %d"
	 adQuery = fmt.Sprintf(adQuery,zninfo.Zoneid)
	 rows, err = db.DbQuery(adQuery)
	 
  

	for rows.Next() {
	 
		 err = helper.Scan(&zoneExtra, rows)
		 
		 		 redisClients.SetKey("zonexchange"+zone_id_str,zoneExtra , time.Minute*5)

			 if err != nil {
				fmt.Println("Failed to run query", err)
				}
		break;
	} 
	 
	}
	


	
	     pub_details := structure.SiteObjects__pub{}

	
	redisClients.GetKey("zonepub"+zone_id_str,&pub_details)
	
	if(pub_details.Id ==""  ) {
		
		
		
 	 adQuery = "SELECT CONVERT(affiliateid,CHAR) as Id,name as Name, website as Domain  FROM "+table_prefix+"affiliates WHERE affiliateid = %d"
	 adQuery = fmt.Sprintf(adQuery,zninfo.Affiliateid)
	 rows, err = db.DbQuery(adQuery)
	 
   

	for rows.Next() {
	 
		 err = helper.Scan(&pub_details, rows)
		 redisClients.SetKey("zonepub"+zone_id_str,pub_details , time.Minute*5)
			 if err != nil {
				fmt.Println("Failed to run query", err)
				}
		break;
	} 
	
	
	}
	
	
	
	
	
	cache_deals := structure.Cache_DealsDetails{}
	
	matchedDeals := [] structure.DealsDetails{}
	
 	 
redisClients.GetKey("is_deals"+zone_id_str,&cache_deals)

  
  if cache_deals.In == 1 {
	  
	  matchedDeals = cache_deals.MatchedDeals
	  
  } else {
	  
  
  
  Query := "SELECT dealid, dealid_token,  auction_type, floor_price, zones, adsize ,whitelist FROM "+table_prefix+"dealid WHERE is_pause= 0 AND is_expire =0 AND is_delete=0 "
  rows, err = db.DbQuery(Query)
	 

	for rows.Next() {
	 
	 	 deals := structure.DealsDetails{}

		 err = helper.Scan(&deals, rows)
		 
			 if err != nil {
				fmt.Println("Failed to run query", err)
				} else {
					
					var dealZones map[interface{}]interface{}
					phpserialize.Unmarshal([]byte(deals.Zones), &dealZones)
						
					for _,zone_id := range dealZones {
						
												
						if zone_id ==  strconv.Itoa(zninfo.Zoneid){
							
												var dealSizes map[interface{}]interface{}
												phpserialize.Unmarshal([]byte(deals.Adsize), &dealSizes)
												
													for _,asize := range dealSizes { 
														
														if asize == fmt.Sprintf("%dx%d",zninfo.Width,zninfo.Height) {
															
															matchedDeals = append(matchedDeals,deals)
															break;
															
														}
														

														
													}
							
											
							break;

						}
						
					}
		
				}
	} 
	  
	
	
		redisClients.SetKey("is_deals"+zone_id_str,structure.Cache_DealsDetails{In : 1 ,MatchedDeals :matchedDeals } , time.Minute*5)
	
		
	}
					

	
		GrobalVariables := globalvariables.SetAllGrobalVariables(r)
		
		var buyers map[interface{}]interface{}
		phpserialize.Unmarshal([]byte(zninfo.Ssp_buyer), &buyers)
		buyer_details := [] structure.ExchangeDetails{}
	
	
	
	for _,buyerid := range buyers {
		 
		 buyer_detail := structure.ExchangeDetails{}
		 
		 

	redisClients.GetKey(fmt.Sprintf("buyer%s",buyerid),&buyer_detail)
	
	if buyer_detail.Exchange_id !=0 { 
		
		buyer_details = append(buyer_details,buyer_detail)
		
		continue;
	}  
	
	
	
	 
		 Colnames := "exchange_id as Exchange_id ,exchange_name as Exchange_name, open_rtb_version as Open_rtb_version , status as Status, ping_url as Ping_url , auction_currency as Auction_currency , auction_type as Auction_type , digital_signature as Digital_signature, gzip as Gzip"		 
		  adQuery = "SELECT "+Colnames+" FROM "+table_prefix+"dj_ad_exchange WHERE exchange_id = %s"
	
	
	
	 adQuery = fmt.Sprintf(adQuery,buyerid)
	 rows, err = db.DbQuery(adQuery)
   
   
   
   
   

	for rows.Next() {
	 
		 err = helper.Scan(&buyer_detail, rows)
		 
			 if err != nil {
				fmt.Println("Failed to run query", err)
				} else {
					
					redisClients.SetKey(fmt.Sprintf("buyer%s",buyerid),buyer_detail , time.Minute*5)
					buyer_details = append(buyer_details,buyer_detail)
				}
				
	}
	
	 
	
		
	}
	
	
	
	
	
	var req interface{}

	 
	if tag_type == "img"  {
		
		if zninfo.Width == -12 && zninfo.Height == -12 {
			
			
			
			
				ssp_req := structure.SspRequestNative{}  
				ssp_req.Id =  rtbOjbects.GetId()
				ssp_req.Dsp =  rtbOjbects.GetDspObj(zninfo,zoneExtra,buyer_details) 
				ssp_req.Imp =  rtbOjbects.GetImpNativeObj(zninfo,zoneExtra,matchedDeals) 
				ssp_req.Site =  rtbOjbects.GetSiteObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Site.Pub = pub_details
				ssp_req.Device =  rtbOjbects.GetDeviceObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Device.Geo =  rtbOjbects.GetGeoObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.User =  rtbOjbects.GetUserObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Tmax= zoneExtra.Req_tmax
				ssp_req.Regs= rtbOjbects.GetRegObj(zninfo,zoneExtra,GrobalVariables) 
				req = ssp_req
				
				
			
				
			} else {
				
				ssp_req := structure.SspRequestImg{}  
				ssp_req.Id =  rtbOjbects.GetId()
				ssp_req.Dsp =  rtbOjbects.GetDspObj(zninfo,zoneExtra,buyer_details) 
				ssp_req.Imp =  rtbOjbects.GetImpImgObj(zninfo,zoneExtra,matchedDeals) 
				ssp_req.Site =  rtbOjbects.GetSiteObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Site.Pub = pub_details
				ssp_req.Device =  rtbOjbects.GetDeviceObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Device.Geo =  rtbOjbects.GetGeoObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.User =  rtbOjbects.GetUserObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Tmax= zoneExtra.Req_tmax
				ssp_req.Regs= rtbOjbects.GetRegObj(zninfo,zoneExtra,GrobalVariables) 
				req = ssp_req
				
			}
		
	} else  if tag_type == "vid-native"   {
		
		
		
		
		
		
		
				ssp_req := structure.SspRequestNative{}  
				ssp_req.Id =  rtbOjbects.GetId()
				ssp_req.Dsp =  rtbOjbects.GetDspObj(zninfo,zoneExtra,buyer_details) 
				ssp_req.Imp =  rtbOjbects.GetVideoNativeObj(zninfo,zoneExtra,matchedDeals) 
				ssp_req.Site =  rtbOjbects.GetSiteObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Site.Pub = pub_details
				ssp_req.Device =  rtbOjbects.GetDeviceObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Device.Geo =  rtbOjbects.GetGeoObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.User =  rtbOjbects.GetUserObj(zninfo,zoneExtra,GrobalVariables) 
				ssp_req.Tmax= zoneExtra.Req_tmax
				ssp_req.Regs= rtbOjbects.GetRegObj(zninfo,zoneExtra,GrobalVariables) 
				req = ssp_req
				
				
			
		
		
		
		
		
		
		
		} else  if tag_type == "vid" ||  tag_type == "audio"  {
		
		
		vast := helper.GetUrlParam(r,"vast")
		protocal := 0
	
		  if tag_type == "vid" { 
		 
		switch (vast) {
			case "vast1" :
				protocal = 1
			case "vast2" :
				protocal = 2
			case "vast3" :
				protocal = 3
			case "vast1_wrapper" :
				protocal = 4
			case "vast2_wrapper" :
				protocal = 5
			case "vast3_wrapper" :
				protocal = 6
			case "vast4" :
				protocal = 7
			case "vast4_wrapper" :
				protocal = 8
			case "daast_1" :
				protocal = 9
			case "daast_1_wapper" :
				protocal = 10
			case "vast4_1" :
				protocal = 11
			case "vast4_1_wrapper" :
				protocal = 12
				
		}
		
		} else  if tag_type == "audio"  {
			
				protocal = 9
		}
		 

		
		
		
	ssp_req := structure.SspRequestVideo{}  
	ssp_req.Id =  rtbOjbects.GetId()
	ssp_req.Dsp =  rtbOjbects.GetDspObj(zninfo,zoneExtra,buyer_details) 
	
	
	ssp_req.Imp =  rtbOjbects.GetImpVidObj(zninfo,zoneExtra,matchedDeals,protocal) 
	
	
	ssp_req.Site =  rtbOjbects.GetSiteObj(zninfo,zoneExtra,GrobalVariables) 
	ssp_req.Site.Pub = pub_details
	ssp_req.Device =  rtbOjbects.GetDeviceObj(zninfo,zoneExtra,GrobalVariables) 
	ssp_req.Device.Geo =  rtbOjbects.GetGeoObj(zninfo,zoneExtra,GrobalVariables) 
	ssp_req.User =  rtbOjbects.GetUserObj(zninfo,zoneExtra,GrobalVariables) 
	ssp_req.Tmax= zoneExtra.Req_tmax
	ssp_req.Regs= rtbOjbects.GetRegObj(zninfo,zoneExtra,GrobalVariables) 
	req = ssp_req
	
	


	}    
		
	
	

    
     
     request_json, _ := json.Marshal(req )
     
      //~ return "",false;
		
	request, err := http.NewRequest("POST",config.GetConfig("mainpath","ssp"), bytes.NewBuffer(request_json))
	request.Header.Set("Content-Type", "application/json")
	client := &http.Client{}
	resp, err := client.Do(request)
	
	if err != nil {
        panic(err)
    }
    defer resp.Body.Close()



	if resp.Status == "200 OK" { 
		
    body, _ := ioutil.ReadAll(resp.Body)
    responseS := structure.ExternalResponse{}
			
	
	 json.Unmarshal([]byte(body), &responseS)
	 
	  
	  
 
	if responseS.Ads.Num1.Adm != "" {
	
		
		if zninfo.Width == -12 && zninfo.Height == -12 {
			
			

			return ad.ExtenalNativeRender(zoneExtra,responseS.Ads.Num1.Adm)+"<img width=0 height=0 src='"+responseS.Ads.Num1.Burl+"'>" , true
			
					
		} else if tag_type == "vid-native"  {
			
			return "" , true

		
			
			
			} else if (tag_type == "vid" || tag_type == "audio" ) && zninfo.Delivery == "10"{
			
			
				respId := responseS.Ads.Num1.ID
				redisClients.SetKey("vidxml"+respId,responseS.Ads.Num1.Adm , time.Minute*5)
				vastresp := config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "?xmlkey=vidxml"+respId
				fmt.Println(vastresp)
				return vastresp,true;	
			} else	if tag_type == "img"  {
		responseS.Ads.Num1.Adm+= "<img width=0 height=0 src='"+responseS.Ads.Num1.Burl+"'>"
		}
		
		return responseS.Ads.Num1.Adm,true;
	} 
 	
 	
 	
	}
	
	
    
	  return "",false;

	
}



 

func GetInternalAds(r *http.Request,zninfo structure.ZoneInfo,ad_type string , adDeliveryType string) (structure.AdDetails ,bool) {
	 
	
		ads_info :=  ad.GetLinkedAdZone(r,zninfo,ad_type)
		adsFiltered,campaign_type := ad.CheckAdCriteria(r,ads_info,zninfo)
		
		
		if len(adsFiltered) > 0 {
		
					adDetails := ad.AdSelect(campaign_type,adsFiltered,zninfo) 
					//~ fmt.Println(zninfo.Delivery)
					
						if zninfo.Delivery == "6" ||  zninfo.Delivery == "7" {
							//~ fmt.Println("ddddddddddddddddd")
							ad.AdRenderVideoAd(&adDetails,zninfo) 
							
							//~ fmt.Println(adDetails)

						}else if  zninfo.Delivery == "10" { 
							if adDeliveryType== "sdk" {
									ad.AdRenderOutstreamVideoAdSDK(&adDetails,zninfo,r) 
								} else
								{
									ad.AdRenderOutstreamVideoAd(&adDetails,zninfo,r)
								}
								
		
					} else if zninfo.Delivery == "12"  {
						ad.AdRenderNativeAd(&adDetails, zninfo) 
						
						} else { 
							ad.AdRender(&adDetails,zninfo,adDeliveryType) 
						}
					 
					return adDetails ,true
		 
		} else { 
			
			if zninfo.Delivery == "6" ||  zninfo.Delivery == "7" {
			
				return structure.AdDetails{  } ,false
			} else { 
				
				return structure.AdDetails{ Html : ad.AdRenderPassBack(zninfo,adDeliveryType) } ,false
			}
			
		}
	
}  

type OutstreamSDKNv_ad struct {
	Ad_type string `json:"ad_type,omitempty"`
	Video string `json:"video,omitempty"`	
	Imptracker []string `json:"imptracker,omitempty"`	
	Clktracker string `json:"clktracker,omitempty"`	
}


func OutstreamSDK(r *http.Request,zninfo structure.ZoneInfo,adDetailsFull structure.AdDetails ,ad_format string,htmltext string,click_url string,imp_url string, sdk_ad_outs  map[string]interface{} ) map[string]interface{}{



	
		
		
		if zninfo.Vidtype == 1 { // aritcle 
		
		sdk_ad_outs["imp_url"] = imp_url
		sdk_ad_outs["click_url"] = click_url
		sdk_ad_outs["ad_type"] = "IN_ART_VID"
		sdk_ad_outs["ad_tag"] = "NAT_INART"
		sdk_ad_outs["Native_ad"] = OutstreamSDKNv_ad{ Ad_type : "IN_ART_VID" ,Video :  htmltext}
					
		
		} else		if zninfo.Vidtype == 3 { // intertital 
		
		sdk_ad_outs["imp_url"] = imp_url
		sdk_ad_outs["click_url"] = click_url
		sdk_ad_outs["ad_type"] = "M_INT_VID"
		sdk_ad_outs["HTML_response"] =htmltext
		sdk_ad_outs["layout"] = zninfo.Layout 
					
	
		
		} else		if zninfo.Vidtype == 4 { // In feed 
			
			
			Getposition := helper.GetUrlParam(r,"position")
			
			if Getposition == "true" { // position 
			 a := make(map[int]interface{}) 
			 position1 := make(map[string]string) 
			
			position := zninfo.Infeedpos;
			repeating := zninfo.Infeedads;
			
					
			arr := strings.Split(position, ",")
			
			for key,value := range arr {
				position1["position"] = value
				a[key] = position1
			}
			
				rep := make(map[string]interface{})
				rep["interval"] = repeating 
	
			
			  sdk_ad_outs["repeating"]  = rep
			  sdk_ad_outs["fixed"]  = a
			
			return sdk_ad_outs
			
			}		



		
		sdk_ad_outs["imp_url"] = imp_url
		sdk_ad_outs["click_url"] = click_url
		sdk_ad_outs["ad_type"] = "IN_FEED_VID"
		sdk_ad_outs["ad_tag"] = "NAT_FEED"
		sdk_ad_outs["Native_ad"] = OutstreamSDKNv_ad{ Ad_type : "IN_FEED_VID" ,
			Imptracker :  []string{click_url},
			Clktracker : click_url, 
			Video :  htmltext}
					
		
		} else	if zninfo.Vidtype == 2	{ // native
			
			
				Getposition := helper.GetUrlParam(r,"position")
			
			if Getposition == "true" { // position 
			 a := make(map[int]interface{}) 
			 position1 := make(map[string]string) 
			
			position := zninfo.Adposition;
			repeating := zninfo.Adinterval;
			
					
			arr := strings.Split(position, ",")
			
			for key,value := range arr {
				position1["position"] = value
				a[key] = position1
			}
			
				rep := make(map[string]interface{})
				rep["interval"] = repeating 
	
			
			  sdk_ad_outs["repeating"]  = rep
			  sdk_ad_outs["fixed"]  = a
			
			return sdk_ad_outs
			
			}
			
			ads := make(map[string]interface{})	
			Native_ad := make(map[string]interface{})	
			
			var bnrParams  map[interface{}]interface{}
			phpserialize.Unmarshal([]byte(adDetailsFull.Parameters), &bnrParams)
			
			ads["imp_url"] = imp_url
			ads["ad_type"] = "M_NAT_VID"
			ads["ad_tag"] = "NAT_CONSTM"
			
			Native_ad["ad_type"]  = "M_NAT_VID"
			Native_ad["title"]  = bnrParams["title"].(string)
			Native_ad["ctatext"]  = bnrParams["cta_text"].(string)
			Native_ad["iconimage"]  = bnrParams["icon_url"].(string)
			Native_ad["imptracker"]  =[1]string{imp_url}
			Native_ad["click_url"]  = click_url
			Native_ad["video"]  = htmltext
			
			ads["Native_ad"] = Native_ad;
			sdk_ad_outs["ads"] = ads;
		
	
			
			
		}  else	if zninfo.Vidtype == 6	{ // Reward
			
			
			rew := strings.Split(zninfo.Reward, "|")
			amt := strings.Split(zninfo.Amount, "|") 
			
			temp := make(map[int]interface{})
			adTag := make(map[string]interface{})
			rewards := make(map[string]interface{})
			
				
			
			for key,value := range rew {
				ga := make(map[string]string)
				ga["amount"] = amt[key]
				ga["name"] = value
				temp[key] = ga
			}
			
			sdk_ad_outs["ad_type"] = "REWARDED_VID"
			
			rewards["rewards"] = temp
			adTag["rewarded_val"] = rewards
			adTag["HTML_response"] = htmltext
			adTag["imp_url"] = imp_url
			adTag["click_url"] = click_url
			adTag["layout"] = zninfo.Position;
			
			sdk_ad_outs["ad_tag"] = adTag;
			
		
							
							
			
		}
		
		
	
	sdk  := make( map[string]interface{} )
	sdk["response"] = "success"
	sdk["ads"] = sdk_ad_outs
	
	return sdk
	
	
} 



func GetZoneDetails(zoneid int,delivery_type string) structure.ZoneInfo {
	
	var zonename string
	var zone_id int
	var affiliateid int
	var delivery string
	var zonetype int
	var width int
	var height int
	var prepend string
	var append string
	var inventory_type int 
	var ssp_buyer string 
	var block int 
	var capping int 
	var session_capping int 
	var inv_type int 
	var passbacktag string 
	var comments string 
	var vidtype int 
	var reward string 
	var amount string 
	var position string 
	var layout string 
	var infeedads string 
	var infeedpos string 
	var adposition string 
	var adinterval string 
	
	zoneid_str := strconv.Itoa(zoneid)
	
	zonein := structure.ZoneInfo{}
	
	//~ fmt.Println("zoneid"+zoneid_str) 
	
	redisClients.GetKey("zoneid"+zoneid_str,&zonein)
  
	if zonein.Zoneid != 0 {
		
		return zonein 
	}
	 
	table_prefix := config.GetConfig("prefix","table")
	
	
		
		DbQuery := "SELECT z.zoneid,z.zonename,z.affiliateid,z.delivery,z.zonetype,z.width,z.height,z.prepend,z.append,z.inventory_type,z.ssp_buyer,z.block,z.capping,z.session_capping,z.inv_type,z.passbacktag ,a.comments ,vidtype,reward,amount	,position,layout,infeedads,infeedpos,adposition,adinterval from "+table_prefix+"zones as z inner join "+table_prefix+"affiliates as a ON a.affiliateid = z.affiliateid where zoneid = %d";	 

		
	DbQuery = fmt.Sprintf(DbQuery,zoneid)
	
	fmt.Println(DbQuery)
		
	zoneDetails := db.DbQueryRow(DbQuery)
	
	zoneDetails.Scan(&zone_id,&zonename,&affiliateid,&delivery,&zonetype,&width,&height,&prepend,&append,&inventory_type,&ssp_buyer,&block,&capping,&session_capping,&inv_type,&passbacktag,&comments,&vidtype,&reward,&amount	,&position,&layout,&infeedads,&infeedpos,&adposition,&adinterval)
	
	var commentsA map[interface{}]interface{}
	if comments !="" {			phpserialize.Unmarshal([]byte(comments), &commentsA)	}
	
	if delivery_type == "sdk" && (commentsA["app_type"] == nil || (commentsA["app_type"].(string) != "1" && commentsA["app_type"].(string) != "2" ) ) { 
		
		return structure.ZoneInfo{}
	}
	
	if delivery_type == "" && (commentsA["app_type"] == nil || commentsA["app_type"].(string) != "3" ) {
		
		return structure.ZoneInfo{}
	}
	
	
	redisClients.SetKey("zoneid"+zoneid_str, structure.ZoneInfo{Zoneid: zone_id, Zonename: zonename, Affiliateid: affiliateid, Delivery: delivery, Zonetype: zonetype, Width: width, Height: height, Prepend: prepend, Append: append, Inventory_type:inventory_type, Ssp_buyer : ssp_buyer,Block:block,Capping:capping,Session_capping:session_capping,Inv_type:inv_type,Passbacktag:passbacktag ,Vidtype : vidtype, Reward: reward , Amount : amount ,Position: position , Layout : layout, Infeedads : infeedads, Infeedpos:infeedpos, Adposition : adposition, Adinterval :adinterval} , time.Minute*5)
	
	
	return structure.ZoneInfo{Zoneid: zone_id, Zonename: zonename, Affiliateid: affiliateid, Delivery: delivery, Zonetype: zonetype, Width: width, Height: height, Prepend: prepend, Append: append, Inventory_type:inventory_type, Ssp_buyer : ssp_buyer,Block:block,Capping:capping,Session_capping:session_capping,Inv_type:inv_type,Passbacktag:passbacktag,Vidtype : vidtype, Reward: reward , Amount : amount ,Position: position , Layout : layout, Infeedads : infeedads, Infeedpos:infeedpos, Adposition : adposition, Adinterval :adinterval}

}



func ConvertJs(html string) string { 
	
	var jsLines [] string
	var search [] string
	var replace [] string 
	
	search = append(search, "\\" )
	search = append(search, "\r" )
	search = append(search, "'" )
	search = append(search, "<" )
	
	replace = append(replace, "\\\\" )
	replace = append(replace, "" )
	replace = append(replace, "\\'" )
	replace = append(replace, "<'+'" )
	
	
	for i, element := range search {
		
 html =  strings.ReplaceAll(html, element, replace[i])
}

lines := strings.Split(html, "\n")


	for _, e := range lines {
		
		if strings.Trim(e, "")  != "" {
			
			jsLines = append(jsLines, "ox_name += '" + strings.Trim(e, "")  +"';\n" )
		}

	
	}
 
buffer := "var ox_name = '';\n "
buffer = buffer+ strings.Join(jsLines, "\n")
buffer = buffer+"\ndocument.write(ox_name);\n"

return buffer

}

 

